----
-- upsidedown project start: 7.11.2014
-- V1.0: released 11.11.2014
-- modules includes: shuttle, manMotorStart, gasGearLimiter

-- changes since last release: xml load cleaned up, more log infos, 
-- added modules: 
--    hourCounter:				operating hours counter
--	  manMotorKeepTurnedOn:		only active with activated manMotorStart!
--	  sensibleSteering: 		removes deadZone for analog steering axis only
--	  handBrake:				see name

-- changes in modules:
--    manMotorStart: using ingame chat or other guis doesnt turn off the motor anymore
--					 rpm indicators now go to zero when motor is off
--					 hired worker stops motor when finished and player has not entered tractor
--	  shuttle:		reverse sound (and probably other things) are now working correctly
--					shuttle now always stops cruise control on braking
--	  gasGearLimiter: values are now saved


driveControl = {};
local driveControl_directory = g_currentModDirectory;




function driveControl:prerequisitesPresent(specializations)
    return true;
	--return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;



function driveControl:load(xmlFile)
	if g_currentMission.driveControl == nil then
		g_currentMission.driveControl = {};
		g_currentMission.driveControl.useModules = {};
		g_currentMission.driveControl.useModules.shuttle = true;		
		g_currentMission.driveControl.useModules.manMotorStart = true;
		g_currentMission.driveControl.useModules.gasGearLimiter = true;
		g_currentMission.driveControl.useModules.hourCounter = true;
		g_currentMission.driveControl.useModules.sensibleSteering = true;
		g_currentMission.driveControl.useModules.manMotorKeepTurnedOn = true;
		g_currentMission.driveControl.useModules.handBrake = true;
		
		
		driveControl:loadConfigFile();
	end;
	
	self.driveControl = {};
	self.driveControl.noEnterCnt = 0;	
	
	self.driveControl.shuttle = {};
	self.driveControl.shuttle.direction = 1.0;
	self.driveControl.shuttle.onOffCnt = 0;
	self.driveControl.shuttle.isActive = true;
		
	self.driveControl.manMotorStart = {};
	self.driveControl.manMotorStart.isActive = true;
	self.driveControl.manMotorStart.isMotorStarted = false;
	self.driveControl.manMotorStart.startCnt = 0;
	self.driveControl.manMotorStart.wasHired = false;
	
	
	self.driveControl.gasGearLimiter = {};
	self.driveControl.gasGearLimiter.gasLimiter = 1.0;
	self.driveControl.gasGearLimiter.gearLimiter = 1.0;
	
	self.driveControl.hourCounter = {};
	self.driveControl.hourCounter.hours = 0;
	
	self.driveControl.handBrake = {};
	self.driveControl.handBrake.isActive = g_currentMission.driveControl.useModules.handBrake;
	
	
	local iconWidth = math.floor(0.0095*1920)/1920;
		
	self.overlayArrowUp = Overlay:new("overlayArrowUp", Utils.getFilename("arrowUp.dds", driveControl_directory), g_currentMission.speedHud.overlayValue1.x+.003,g_currentMission.speedHud.overlayValue1.y+0.076, iconWidth, iconWidth*16/9);
	self.overlayArrowDown = Overlay:new("overlayArrowDown", Utils.getFilename("arrowDown.dds", driveControl_directory), g_currentMission.speedHud.overlayValue1.x+.003,g_currentMission.speedHud.overlayValue1.y+0.076, iconWidth, iconWidth*16/9);
	
	self.overlayBattery = Overlay:new("overlayBattery", Utils.getFilename("battery.dds", driveControl_directory), g_currentMission.speedHud.overlayValue1.x+.037,g_currentMission.speedHud.overlayValue1.y+0.076, iconWidth, iconWidth*16/9);
	self.overlayPreHeat = Overlay:new("overlayPreHeat", Utils.getFilename("preHeat.dds", driveControl_directory), g_currentMission.speedHud.overlayValue1.x+.037,g_currentMission.speedHud.overlayValue1.y+0.076, iconWidth, iconWidth*16/9);
	
	
	self.overlayGears = Overlay:new("overlayGears", Utils.getFilename("gears.dds", driveControl_directory), g_currentMission.speedHud.overlayValue1.x+.037,g_currentMission.speedHud.overlayValue1.y+0.006, iconWidth, iconWidth*16/9);
	self.overlayPedals = Overlay:new("overlayPedals", Utils.getFilename("pedal.dds", driveControl_directory), g_currentMission.speedHud.overlayValue1.x+.003,g_currentMission.speedHud.overlayValue1.y+0.006, iconWidth, iconWidth*16/9);
	
	
	self.overlayHourGlass = Overlay:new("overlayHourGlass", Utils.getFilename("hourGlass.dds", driveControl_directory), g_currentMission.speedHud.overlayValue1.x+.049,g_currentMission.speedHud.overlayValue1.y-.002, 0.5*iconWidth, 0.5*iconWidth*16/9);
	
	self.overlayHandBrake = Overlay:new("overlayHandBrake", Utils.getFilename("handBrake.dds", driveControl_directory), g_currentMission.speedHud.overlayValue1.x+.049,g_currentMission.speedHud.overlayValue1.y+0.076, 1.0*iconWidth, 1.0*iconWidth*16/9);
	
	
	
end;


function driveControl:postLoad(xmlFile)
	if g_currentMission.driveControl.useModules.manMotorKeepTurnedOn then
		if g_currentMission.driveControl.useModules.manMotorStart then
			self.stopMotorOnLeave = false;
			self.deactivateLightsOnLeave = false;
			self.deactivateOnLeave = false;
		end;
	end;
	
	if g_currentMission.driveControl.useModules.handBrake then
		self.driveControl.handBrake.normalBrakeForce = self.motor.brakeForce;
		print("normal brakeForce archived")
	end;
	
	--self.motor.minForwardGearRatio = 5*self.motor.minForwardGearRatio;    -- <== this makes full rpm at low speed
	 
	if g_currentMission.driveControl.useModules.gasGearLimiter then
		self.driveControl.gasGearLimiter.originalMinForwardGearRatio = self.motor.minForwardGearRatio;
		self.driveControl.gasGearLimiter.originalMaxForwardGearRatio = self.motor.maxForwardGearRatio;
	
	end;
	
	self.driveControl.manMotorStart.motorMinRpm = self.motor.minRpm;
	
	if g_currentMission.driveControl.useModules.sensibleSteering then
		if driveControl.deadZone == nil then
			driveControl.deadZone = driveControl.loadedDeadZone; --getGamepadDefaultDeadzone();
			
			setGamepadDefaultDeadzone(0);
			InputBinding.update = Utils.overwrittenFunction(InputBinding.update,driveControl.IPTupdate);
		end;
	end;
end;

function driveControl.IPTupdate(self,oldFunc,dt)
	--
	oldFunc(dt)
	-- 
	for actionIndex, actionData in pairs(InputBinding.actions) do
		if actionData.isAnalogAction then
			if actionData.lastInputType == InputBinding.INPUTTYPE_GAMEPAD_AXIS then
				if actionIndex ~= InputBinding["AXIS_MOVE_SIDE_VEHICLE"] then
					local deadZone = Utils.getNoNil(driveControl.deadZone,0.1);
					if math.abs(actionData.lastInputAxis) < deadZone then
						actionData.lastInputAxis = 0;
					else
						local minus = actionData.lastInputAxis < 0;
						actionData.lastInputAxis = (math.abs(actionData.lastInputAxis) - deadZone)/(1-deadZone);
						if minus then
							actionData.lastInputAxis = -actionData.lastInputAxis;
						end;
					end;
				end;
			end;
		end;
	end;
	
end;

function driveControl:motorStop(self,doStopSounds)	
	self.isMotorStarted = false;
	if Utils.getNoNil(doStopSounds,false) then
		self:stopMotor(true);
	else
		Motorized.stopSounds(self);
		if self.exhaustParticleSystems ~= nil then
			Utils.setEmittingState(self.exhaustParticleSystems, false)
		end;
		
		if self.exhaustEffects~= nil then
			for _,effect in pairs(self.exhaustEffects) do
				setVisibility(effect.node,false);
			end;
		end;
	end;
	
	self.motor.minRpm = 0;
	--print("motor turned off on enter")
end;


function driveControl:motorStart(self)
	-- self:startMotor(g_server == nil);
	self:startMotor(true);
	if self.exhaustParticleSystems ~= nil then
		Utils.setEmittingState(self.exhaustParticleSystems, true)
	end;
	
	if self.exhaustEffects~= nil then
		for _,effect in pairs(self.exhaustEffects) do
			setVisibility(effect.node,true);
		end;
	end;
	self.motor.minRpm = self.driveControl.manMotorStart.motorMinRpm;
end;

function driveControl:onLeave()
	-- print("dC: leave")
	if g_currentMission.driveControl.useModules.manMotorKeepTurnedOn then
		
		self.forceIsActive = false;		
		for _,implement in pairs(self.attachedImplements) do
			implement.object.forceIsActive = false;
		end;
	end;
end;


function driveControl:onEnter()
	if g_currentMission.driveControl.useModules.manMotorStart then
		if not self.driveControl.manMotorStart.isMotorStarted then
			driveControl:motorStop(self,false)
		end;
	end;
end;

-- function driveControl:aiTurnOff()
	-- print("AI off!")
-- end;

function driveControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function driveControl:keyEvent(unicode, sym, modifier, isDown)
end;

function driveControl:newOnLeave(...)
	-- print("leave: "..tostring(self))
	if self.driveControl ~= nil then --drivable
		if self.driveControl ~= nil and g_currentMission.driveControl.useModules.manMotorStart and self.driveControl.manMotorStart.isMotorStarted then
			-- print("on leave dummy")
			if g_currentMission.controlledVehicles[self] ~= nil then
				
				-- print(self.beaconLightsActive)
				-- print(self.turnSignalState)
				-- print(self.lightsState)
				
				-- local beacon = self.beaconLightsActive;
				-- local blinker = self.turnSignalState;
				-- local light = self.lightsState;
				
				--Steerable.onLeave(self)
				
				self.isEntered = false
				self.isControlled = false
				g_currentMission.controlledVehicles[self] = nil
				if not self.isHired then
					-- if self.characterNode ~= nil then
						-- setVisibility(self.characterNode,false);
					-- end;
					self:setCharacterVisibility(false)
				end;
				
				-- self.beaconLightsActive = beacon
				-- self.turnSignalState = blinker
				-- self.lightsState = light
				-- self:setLights(light,true);
				
				-- print("steerable leave")
				-- print(self.beaconLightsActive)
				-- print(self.turnSignalState)
				-- print(self.lightsState)
				-- print("================")
			end;
		else
			-- print("calling normal leave functions")
			local func = "onLeave";
			--return function(self, ...)
			for k, v in pairs(self.specializations) do
				local f = v[func]
				if f ~= nil then
					-- print(k)
					f(self, ...);
				end
			end
			--end
		end;
		
		
	-- else --newOnLeave for implements?!
		-- print("implements?!")
	end;
end;

function driveControl:updateTick(dt)

	-- self.motor.brakeForce = 90000;

	
	if g_currentMission.driveControl.useModules.manMotorKeepTurnedOn then
		if g_currentMission.driveControl.useModules.manMotorStart then
			self.stopMotorOnLeave = false;
			self.deactivateLightsOnLeave = false;
			self.deactivateOnLeave = false;
		end;
	end;
	
	
	if g_currentMission.driveControl.useModules.manMotorKeepTurnedOn then		
		if self.driveControl.manMotorStart.isMotorStarted then
			self.forceIsActive = true;
			self.onLeave = driveControl.newOnLeave;
			for _,implement in pairs(self.attachedImplements) do
				implement.object.forceIsActive = true;				
			end;
		end;
	end;
		
	if g_currentMission.driveControl.useModules.hourCounter then
		if self.isMotorStarted then
			self.driveControl.hourCounter.hours = self.driveControl.hourCounter.hours + 1.0*dt/(1000*3600);			
		end;
	end;
	
	
	if g_currentMission.driveControl.useModules.manMotorStart then
		if self.isHired then
			self.driveControl.manMotorStart.isMotorStarted = true;
			self.driveControl.manMotorStart.wasHired = true;
		else
			if self.driveControl.manMotorStart.wasHired then				
				if not self.isEntered then
					self.driveControl.manMotorStart.isMotorStarted = false;
				end;
			end;
			self.driveControl.manMotorStart.wasHired = false;
		end;
		if self.driveControl.manMotorStart.isMotorStarted ~= self.isMotorStarted then
			if self.driveControl.manMotorStart.isMotorStarted then --turn on
				driveControl:motorStart(self)
			else --turn off
				driveControl:motorStop(self,true)
			end;		
		end;	
	end;
	
	if g_currentMission.driveControl.useModules.gasGearLimiter then
		if self.isServer then
			local overDrive = 2.0;
			
			local factor = 1/self.driveControl.gasGearLimiter.gearLimiter;
			
			local maxFac = self.driveControl.gasGearLimiter.originalMaxForwardGearRatio/self.driveControl.gasGearLimiter.originalMinForwardGearRatio;
			--print(maxFac)
			
			factor = Utils.clamp(factor,1.0,overDrive*maxFac);
			
			self.motor.minForwardGearRatio = factor * self.driveControl.gasGearLimiter.originalMinForwardGearRatio;
			if factor > maxFac then --we do gear overdrive
				self.motor.maxForwardGearRatio = self.motor.minForwardGearRatio;
				--print("overdrive")
			else
				self.motor.maxForwardGearRatio = self.driveControl.gasGearLimiter.originalMaxForwardGearRatio;
			end;
			
			--self.motor.minForwardGearRatio = self.driveControl.gasGearLimiter.originalMinForwardGearRatio;
			
			
		end;
	end;
	
	--self.driveControl.gasGearLimiter.gearLimiter
	
end;

function driveControl:update(dt)
	
	if g_gui.currentGuiName == nil or g_gui.currentGuiName == "" then
		self.driveControl.noEnterCnt = math.max(self.driveControl.noEnterCnt - 1,-1);
	else
		self.driveControl.noEnterCnt = 20;
	end;
	
		
	if self:getIsActiveForInput(false) or (g_currentMission.controlledVehicle == self and g_gui.currentGuiName == nil) then 
		if self.driveControl.noEnterCnt > 0 then
			return;
		end;
		
		if g_currentMission.driveControl.useModules.manMotorStart then --manual motor start
			if self.driveControl.manMotorStart.isMotorStarted then
				if InputBinding.hasEvent(InputBinding.driveControlMotor) then --turn off
					self.driveControl.manMotorStart.isMotorStarted = false;
					driveControlInputEvent.sendEvent(self)
					--driveControl:motorStop(self,true)
				end;
				self.driveControl.manMotorStart.startCnt = 0;
			else
				if InputBinding.isPressed(InputBinding.driveControlMotor) then
					self.driveControl.manMotorStart.startCnt = self.driveControl.manMotorStart.startCnt + dt;
				else
					self.driveControl.manMotorStart.startCnt = 0;
				end;
				
				if self.driveControl.manMotorStart.startCnt > 800 then --turn on
					--print("start")
					--driveControl:motorStart(self)
					self.driveControl.manMotorStart.isMotorStarted = true;
					driveControlInputEvent.sendEvent(self)
				end;
			
			end;
		end;
		---------------------------------
		
		if g_currentMission.driveControl.useModules.gasGearLimiter then
			
			local change = 0.0002*dt;
			if InputBinding.isPressed(InputBinding.driveControlGearLimiterUp) then
				local oldValue = self.driveControl.gasGearLimiter.gearLimiter;
				self.driveControl.gasGearLimiter.gearLimiter = self.driveControl.gasGearLimiter.gearLimiter + change;
				self.driveControl.gasGearLimiter.gearLimiter = Utils.clamp(self.driveControl.gasGearLimiter.gearLimiter,0,1);
				if self.driveControl.gasGearLimiter.gearLimiter ~= oldValue then
					driveControlInputEvent.sendEvent(self);
					-- print("gear: ",self.driveControl.gasGearLimiter.gearLimiter*100)
				end;
			end;
			
			if InputBinding.isPressed(InputBinding.driveControlGearLimiterDown) then
				local oldValue = self.driveControl.gasGearLimiter.gearLimiter;
				self.driveControl.gasGearLimiter.gearLimiter = self.driveControl.gasGearLimiter.gearLimiter - change;
				self.driveControl.gasGearLimiter.gearLimiter = Utils.clamp(self.driveControl.gasGearLimiter.gearLimiter,0,1);
				if self.driveControl.gasGearLimiter.gearLimiter ~= oldValue then
					driveControlInputEvent.sendEvent(self);
					-- print("gear: ",self.driveControl.gasGearLimiter.gearLimiter*100)
				end;
			end;
			
			if InputBinding.isPressed(InputBinding.driveControlGasLimiterUp) then
				local oldValue = self.driveControl.gasGearLimiter.gasLimiter;
				self.driveControl.gasGearLimiter.gasLimiter = self.driveControl.gasGearLimiter.gasLimiter + change;
				self.driveControl.gasGearLimiter.gasLimiter = Utils.clamp(self.driveControl.gasGearLimiter.gasLimiter,0,1);
				if self.driveControl.gasGearLimiter.gasLimiter ~= oldValue then
					driveControlInputEvent.sendEvent(self);
					-- print("gas: ",self.driveControl.gasGearLimiter.gasLimiter*100)
				end;
			end;
			
			if InputBinding.isPressed(InputBinding.driveControlGasLimiterDown) then
				local oldValue = self.driveControl.gasGearLimiter.gasLimiter;
				self.driveControl.gasGearLimiter.gasLimiter = self.driveControl.gasGearLimiter.gasLimiter - change;
				self.driveControl.gasGearLimiter.gasLimiter = Utils.clamp(self.driveControl.gasGearLimiter.gasLimiter,0,1);
				if self.driveControl.gasGearLimiter.gasLimiter ~= oldValue then
					driveControlInputEvent.sendEvent(self);
					-- print("gas: ",self.driveControl.gasGearLimiter.gasLimiter*100)
				end;
			end;
			
		
		end;
	
		---------------------------------
		
		if g_currentMission.driveControl.useModules.handBrake then
			if InputBinding.hasEvent(InputBinding.driveControlHandbrake) then
				self.driveControl.handBrake.isActive = not self.driveControl.handBrake.isActive;
				--print("handbrake: "..tostring(self.driveControl.handBrake.isActive))
				driveControlInputEvent.sendEvent(self) 
			end;
		end;
		
		
		if g_currentMission.driveControl.useModules.shuttle then
			
			if InputBinding.isPressed(InputBinding.driveControlShuttle) then
				self.driveControl.shuttle.onOffCnt = self.driveControl.shuttle.onOffCnt + dt;
			else
				self.driveControl.shuttle.onOffCnt = 0;
			end;
			if self.driveControl.shuttle.onOffCnt > 2500 then
				self.driveControl.shuttle.isActive = not self.driveControl.shuttle.isActive;
				self.driveControl.shuttle.onOffCnt = -100000000000000000000000;
				--print("shuttle turned ",self.driveControl.shuttle.isActive)				
				driveControlInputEvent.sendEvent(self) 
			end;
			
			if self.driveControl.shuttle.isActive then
				if InputBinding.hasEvent(InputBinding.driveControlShuttle) then
					self.driveControl.shuttle.direction = -self.driveControl.shuttle.direction;					
					driveControlInputEvent.sendEvent(self)
				end;
			end;
		end;
				
	end;
end;


function driveControl:draw()
		
	if g_currentMission.driveControl.useModules.handBrake then
		if self.driveControl.handBrake.isActive then
			self.overlayHandBrake:render();
		end;
	end;
	
	
	if g_currentMission.driveControl.useModules.hourCounter then
		--render icon:render();
		--self.driveControl.hourCounter.hours
		self.overlayHourGlass:render();
		
		setTextBold(false);
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(0.6307, 0.6307, 0.6307, 1);
		-- local str = tostring(math.floor(self.driveControl.hourCounter.hours*10)/10).." h"
		local str = string.format("%.1f h",self.driveControl.hourCounter.hours);
		renderText(g_currentMission.speedHud.overlayValue1.x+.055,g_currentMission.speedHud.overlayValue1.y,g_currentMission.speedUnitTextSize,str)
		
	
	end;
	
	if g_currentMission.driveControl.useModules.manMotorStart then
		if not self.driveControl.manMotorStart.isMotorStarted then
			if self.driveControl.manMotorStart.startCnt > 0 then
				self.overlayPreHeat:render();
			else
				self.overlayBattery:render();
			end;		
		end;
	end;
	
	if g_currentMission.driveControl.useModules.shuttle then
		if self.driveControl.shuttle.isActive then
			if self.driveControl.shuttle.direction > 0 then
				self.overlayArrowUp:render();
			else
				self.overlayArrowDown:render();
			end;
		end;
	end;
	
	if g_currentMission.driveControl.useModules.gasGearLimiter then
		self.overlayGears:render()
		self.overlayPedals:render()
		
		setTextBold(false);
		setTextAlignment(RenderText.ALIGN_CENTER);
		setTextColor(0.6307, 0.6307, 0.6307, 1);
		local str = tostring(math.floor(self.driveControl.gasGearLimiter.gasLimiter*100)).."%"
		renderText(g_currentMission.speedHud.overlayValue1.x+.009,g_currentMission.speedHud.overlayValue1.y,g_currentMission.speedUnitTextSize,str)
		
		str = tostring(math.floor(self.driveControl.gasGearLimiter.gearLimiter*100)).."%"
		renderText(g_currentMission.speedHud.overlayValue1.x+.04,g_currentMission.speedHud.overlayValue1.y,g_currentMission.speedUnitTextSize,str)
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(1, 1, 1, 1);
	end;			
end;


function driveControl:getSaveAttributesAndNodes(nodeIdent)
	-- local attributes = "";	
	local hours = Utils.getNoNil(self.driveControl.hourCounter.hours,0);
	local gasLimiter = Utils.getNoNil(self.driveControl.gasGearLimiter.gasLimiter,1.0);
	local gearLimiter = Utils.getNoNil(self.driveControl.gasGearLimiter.gearLimiter,1.0);
	local attributes = 'gasLimiter="'..tostring(gasLimiter)..'" gearLimiter="'..tostring(gearLimiter)..'" workingHours="'..tostring(hours)..'"';
	
	--  = 1.0;
	-- self.driveControl.gasGearLimiter.gearLimiter = 1.0;
	
	return attributes
end;


function driveControl:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local hours = getXMLFloat(xmlFile, key.."#workingHours");
	self.driveControl.hourCounter.hours = Utils.getNoNil(hours,0);
	
	local gasLimiter = getXMLFloat(xmlFile, key.."#gasLimiter");
	local gearLimiter = getXMLFloat(xmlFile, key.."#gearLimiter");
	self.driveControl.gasGearLimiter.gasLimiter = Utils.getNoNil(gasLimiter,1.0);
	self.driveControl.gasGearLimiter.gearLimiter = Utils.getNoNil(gearLimiter,1.0);
	
	
	
	if not resetVehicles then
		
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end

function driveControl:writeStream(streamId, connection)
	streamWriteBool(streamId, g_currentMission.driveControl.useModules.shuttle);
	streamWriteBool(streamId, g_currentMission.driveControl.useModules.manMotorStart);
	streamWriteBool(streamId, g_currentMission.driveControl.useModules.gasGearLimiter);
	streamWriteBool(streamId, g_currentMission.driveControl.useModules.hourCounter);
	
	streamWriteBool(streamId, self.driveControl.shuttle.isActive);
	streamWriteFloat32(streamId, self.driveControl.shuttle.direction);
	streamWriteBool(streamId, self.driveControl.manMotorStart.isMotorStarted);
	streamWriteFloat32(streamId, self.driveControl.gasGearLimiter.gasLimiter);
	streamWriteFloat32(streamId, self.driveControl.gasGearLimiter.gearLimiter);
	streamWriteFloat32(streamId, self.driveControl.hourCounter.hours);
	streamWriteBool(streamId, self.driveControl.handBrake.isActive);
end;

function driveControl:readStream(streamId, connection) --sry, the server wins ;)
	g_currentMission.driveControl.useModules.shuttle = streamReadBool(streamId);
	g_currentMission.driveControl.useModules.manMotorStart = streamReadBool(streamId);
	g_currentMission.driveControl.useModules.gasGearLimiter = streamReadBool(streamId);
	g_currentMission.driveControl.useModules.hourCounter = streamReadBool(streamId);
	
	local shuttleActive = streamReadBool(streamId);
	local shuttle = streamReadFloat32(streamId);
	local isMotorStarted = streamReadBool(streamId);
	local gasLimiter = streamReadFloat32(streamId);
	local gearLimiter = streamReadFloat32(streamId);
	local hours = streamReadFloat32(streamId);
	local handBrake = streamReadBool(streamId);
	
	self.driveControl.shuttle.isActive = shuttleActive;
	self.driveControl.shuttle.direction = shuttle;
	self.driveControl.manMotorStart.isMotorStarted = isMotorStarted;
	self.driveControl.gasGearLimiter.gasLimiter = gasLimiter;
	self.driveControl.gasGearLimiter.gearLimiter = gearLimiter;
	self.driveControl.hourCounter.hours = hours;
	self.driveControl.handBrake.isActive = handBrake;
end;

function driveControl:delete()	
end

function driveControl:loadConfigFile()
	local path = getUserProfileAppPath();
	local Xml;
	local file = path.."/driveControl_config.xml";
		
	if fileExists(file) then
		print("loading "..file.." for driveControl-Mod configuration");
		Xml = loadXMLFile("driveControl_XML", file, "driveControl");		
	else
		print("creating "..file.." for driveControl-Mod configuration");
		Xml = createXMLFile("driveControl_XML", file, "driveControl");
	end;
	
	local moduleList = {"shuttle", "manualMotorStart","manMotorKeepTurnedOn","gasAndGearLimiter","hourCounter","sensibleSteering","handBrake"};
	
	for _,field in pairs(moduleList) do
		local XmlField = string.upper(string.sub(field,1,1))..string.sub(field,2);
		
		local res = getXMLBool(Xml, "driveControl.Modules."..XmlField);
		if res ~= nil then
			g_currentMission.driveControl.useModules[field] = res;
			if res then
				print("driveControl module "..field.." started")
			else
				print("driveControl module "..field.." not started");
			end;
		else
			setXMLBool(Xml, "driveControl.Modules."..XmlField, true);
			print("driveControl module "..field.." inserted into xml and started");
		end;
	end;
	
	if g_currentMission.driveControl.useModules.sensibleSteering then
		local res = getXMLFloat(Xml, "driveControl.SensibleSteering.deadZone");
		if res ~= nil then
			driveControl.loadedDeadZone = res;
			print("driveControl sensibleSteering deadZone set to "..tostring(math.floor(driveControl.loadedDeadZone*100)).."%")
		else
			driveControl.loadedDeadZone = getGamepadDefaultDeadzone();
			setXMLFloat(Xml, "driveControl.SensibleSteering.deadZone", driveControl.loadedDeadZone);
			print("driveControl sensibleSteering inserted into xml");
		end;		
	end;
		
	saveXMLFile(Xml);
end;



if Drivable.driveControlInstalled == nil then
	print("--- installing driveControl by upsidedown into Drivable and Steerable...")
	local oldFunc = Drivable.updateVehiclePhysics;
	function Drivable.updateVehiclePhysics(self, axisForward, axisForwardIsAnalog, axisSide, axisSideIsAnalog, dt)
		
		if g_currentMission.driveControl.useModules.handBrake then				
			if self.driveControl.handBrake.isActive then -- just a dummy for handbrake
				axisForward = 0;				
				self.motor.brakeForce = 1000000;
				 -- if self.isServer then
                     -- for k,wheel in pairs(self.wheels) do
                         -- setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
                     -- end;
                 -- end;
				
				
			else
				self.motor.brakeForce = self.driveControl.handBrake.normalBrakeForce; --reset to old stored value
			end;
		end;		
		
		if g_currentMission.driveControl.useModules.shuttle and self.driveControl.shuttle.isActive then --and not self.cruiseControl.isActive
			
			--print(self.movingDirection," ",self.driveControl.shuttle.direction," ",self.vehicleMovingDirection)			
			if self.driveControl.shuttle.direction < 0 and self.cruiseControl.state == 0 then
				axisForward = -axisForward;
				self.axisForward = -self.axisForward;
			end;
			
			if self.movingDirection ~= self.driveControl.shuttle.direction then
				if self.driveControl.shuttle.direction < 0 then
					axisForward = Utils.clamp(axisForward,0,1);			
				else
					axisForward = Utils.clamp(axisForward,-1,0);			
				end;
			end;
						
			self.GPSmovingDirection = self.driveControl.shuttle.direction;
			self.GPSmovingDirectionCnt = 40; --here we remotely handle direction mechanics from GPS. no problem if GPS is not installed			
		end;		
		
		if g_currentMission.driveControl.useModules.gasGearLimiter and self.cruiseControl.state == 0  then

			if self.driveControl.gasGearLimiter.gasLimiter < 1.0 then
				local axisFactor = self.driveControl.gasGearLimiter.gasLimiter;
				
				local maxSpeed = Utils.getNoNil(self.cruiseControl.maxSpeed,40)*self.driveControl.gasGearLimiter.gasLimiter
				local alpha = (maxSpeed - self.lastSpeed*3600)/maxSpeed;
				alpha = Utils.clamp(alpha,0,1);
				--print(alpha)
				axisFactor = alpha*axisFactor;
				-- local directionAxis = axisForward;
				-- if g_currentMission.driveControl.useModules.shuttle and self.driveControl.shuttle.isActive and self.driveControl.shuttle.direction < 0 then
					-- directionAxis = -directionAxis;
				-- end;
				
				-- if directionAxis < 0 then
					axisForward = axisForward*axisFactor; 
					axisForwardIsAnalog = true; 
				-- end;
			end;
		end;
		
		
		oldFunc(self, axisForward, axisForwardIsAnalog, axisSide, axisSideIsAnalog, dt)
	end;

	
	
	local oldFunc2 = Steerable.update;
	function Steerable.update(self,dt)
		if g_currentMission.controlledVehicle == self then
			if g_currentMission.driveControl.useModules.gasGearLimiter then
				if InputBinding.isPressed(InputBinding.driveControlGasLimiterUp) then
					InputBinding.actions[InputBinding.AXIS_LOOK_UPDOWN_VEHICLE].lastInputAxis = 0;
				end;
				
				if InputBinding.isPressed(InputBinding.driveControlGasLimiterDown) then
					InputBinding.actions[InputBinding.AXIS_LOOK_UPDOWN_VEHICLE].lastInputAxis = 0;
				end;
				
				if InputBinding.isPressed(InputBinding.driveControlGearLimiterUp) then
					InputBinding.actions[InputBinding.AXIS_LOOK_LEFTRIGHT_VEHICLE].lastInputAxis = 0;
				end;
				
				if InputBinding.isPressed(InputBinding.driveControlGearLimiterDown) then
					InputBinding.actions[InputBinding.AXIS_LOOK_LEFTRIGHT_VEHICLE].lastInputAxis = 0;
				end;
			end;
		end;
		
		oldFunc2(self,dt);
	end;
	
	Drivable.driveControlInstalled = true;
end;





driveControlInputEvent = {};
driveControlInputEvent_mt = Class(driveControlInputEvent, Event);

InitEventClass(driveControlInputEvent, "driveControlInputEvent");

function driveControlInputEvent:emptyNew()
    local self = Event:new(driveControlInputEvent_mt);
    self.className="driveControlInputEvent";
    return self;
end;

function driveControlInputEvent:new(vehicle)
    local self = driveControlInputEvent:emptyNew()
    self.vehicle = vehicle;
	self.shuttleActive = vehicle.driveControl.shuttle.isActive
	self.shuttle = vehicle.driveControl.shuttle.direction;
	self.isMotorStarted = vehicle.driveControl.manMotorStart.isMotorStarted;
	self.gasLimiter = vehicle.driveControl.gasGearLimiter.gasLimiter;
	self.gearLimiter = vehicle.driveControl.gasGearLimiter.gearLimiter;
	self.handBrake = vehicle.driveControl.handBrake.isActive
	-- print("event new")
    return self;
end;

function driveControlInputEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.shuttleActive);
	streamWriteFloat32(streamId, self.shuttle);
	streamWriteBool(streamId, self.isMotorStarted);
	streamWriteFloat32(streamId, self.gasLimiter);
	streamWriteFloat32(streamId, self.gearLimiter);
	streamWriteBool(streamId, self.handBrake);
	-- print("event writeStream")
end;

function driveControlInputEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    local vehicle = networkGetObject(id);
	
	local shuttleActive = streamReadBool(streamId);
	local shuttle = streamReadFloat32(streamId);
	local isMotorStarted = streamReadBool(streamId);
	local gasLimiter = streamReadFloat32(streamId);
	local gearLimiter = streamReadFloat32(streamId);
	local handBrake = streamReadBool(streamId);
	
	vehicle.driveControl.shuttle.isActive = shuttleActive;
	vehicle.driveControl.shuttle.direction = shuttle;
	vehicle.driveControl.manMotorStart.isMotorStarted = isMotorStarted;
	vehicle.driveControl.gasGearLimiter.gasLimiter = gasLimiter;
	vehicle.driveControl.gasGearLimiter.gearLimiter = gearLimiter;
	vehicle.driveControl.handBrake.isActive = handBrake;
	-- print("event readStream")
	-- print(shuttleActive,shuttle,isMotorStarted,gasLimiter,gearLimiter)
	if g_server ~= nil then	
		g_server:broadcastEvent(driveControlInputEvent:new(vehicle), nil, nil, vehicle);
		-- print("broadcasting")
	end;
end;

function driveControlInputEvent.sendEvent(vehicle)
	if g_server ~= nil then	
		--g_server:broadcastEvent(driveControlInputEvent:new(vehicle), nil, nil, self);
		-- print("broadcasting")
	else
		g_client:getServerConnection():sendEvent(driveControlInputEvent:new(vehicle));
		-- print("sending event to server...")
	end;
end;