--
-- multiMowing
-- 
-- 
--
-- upsideDown start: 18.12.2013
-- project beta status: 08.01.2014 SP complete
-- added "green windrow" option, still SP only
-- MP code inserted: 25.01.2014
-- added support for MR1.2(beta) and - hopefully - higher
-- final parameter tuning: 30.01.2014
-- adapted for slurry/manure V2.0:   01.02.2014

FruitUtil.registerFruitType("green", g_i18n:getText("green"),
  false, false, false, 0, 4, 6, 8, false, 0.29, 1.2, 0.1, false,
  "",nil);
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_GREEN,
  "green_windrow", g_i18n:getText("green_windrow"), 0.04, 3, false,
  nil);

multiMowing = {};
addModEventListener(multiMowing);


function multiMowing:loadMap(name)	
	print("--- loading multiMowing mod V1.0 --- (by upsidedown)")
		
	
	MowerAreaEvent.runLocally = multiMowing.runLocally; -- we do the overwrite here, otherwise old MR versions and some other mods can mess this mod up
	MowerAreaEvent.runLocallyMR = multiMowing.runLocally; --make compatible with MR1.2 --thx dural for cleaning up :)
	MowerAreaEvent.readStream = multiMowing.newReadStream;
	MowerAreaEvent.writeStream = multiMowing.newWriteStream;
	
	multiMowing.manureFactor = 1.0;
	
	multiMowing.grassSum = 0;
	multiMowing.manureSum = 0;
	multiMowing.modGrassSum = 0;
	
	
	g_currentMission.numWindrowChannels = 5--lets do evil things...
    g_currentMission.maxWindrowValue = 31--but it really seems to work..

	--multiMowing.greenWindrowId = getChild(g_currentMission.terrainRootNode, "green_windrow");
end;

function multiMowing:deleteMap()
end


function multiMowing:mouseEvent(posX, posY, isDown, isUp, button)
end;

function multiMowing:keyEvent(unicode, sym, modifier, isDown)
end;


function multiMowing:update(dt)	
end


function multiMowing:draw()   
end;


function multiMowing.runLocally(areas, numAreas, dropAreas, numDropAreas)
	
	 local totalAreaMowed = 0;--compatible with MR1.2
	 
	 local doGPSwindrow = false;
	 local GPSwindrowFruit = FruitUtil.FRUITTYPE_GRASS;
	 
	 for fruitType,entry in pairs(g_currentMission.fruits) do
		local desc = FruitUtil.fruitIndexToDesc[fruitType];
		if desc.name == "green" then
			doGPSwindrow = true;
			GPSwindrowFruit = desc.index;
		end;
	 end;
	 -- if multiMowing.greenWindrowId ~= nil then
		-- print("we have green windrow!")
		-- GPSwindrowFruit = multiMowing.greenWindrowId;
	 -- end;
	 
     local params = g_currentMission.areaCompressionParams;
     local paramsRelative = g_currentMission.areaRelativeCompressionParams;
 
     local pickedUpWindrow = 0;
     local numAreasUsed = 0;
     local numDropAreasUsed = 0;
	 local doGW = false;
	 local maxFruit = FruitUtil.FRUITTYPE_UNKNOWN;
     for i=1, numAreas do
         local area = areas[i];
 
         local x = Utils.simWriteCompressedWorldPosition(area.x, params);
         local z = Utils.simWriteCompressedWorldPosition(area.z, params);
         local x1 = x + Utils.simWriteCompressedWorldPosition(area.x1 - area.x, paramsRelative);
         local z1 = z + Utils.simWriteCompressedWorldPosition(area.z1 - area.z, paramsRelative);
         local x2 = x + Utils.simWriteCompressedWorldPosition(area.x2 - area.x, paramsRelative);
         local z2 = z + Utils.simWriteCompressedWorldPosition(area.z2 - area.z, paramsRelative);
 
         local areaChanged = 0;
		
		 local maxFruitValue = 0;
		 local needGPSwindrow = false;

         if area.dropArea ~= nil then			
			local manureBonus = Utils.getNoNil(area.manureAcc);
			 local newManure = 0;
             
			 areaChanged,newManure = multiMowing.updateMeadowArea(x, z, x1, z1, x2, z2, false,manureBonus);
			 totalAreaMowed = totalAreaMowed + areaChanged; --areaChanged is used for more things in multiMowing, so we need to do the stats in smaller steps
			 
			 area.manureAcc = math.min(newManure,100);
		     local areaGrass = areaChanged;
		 
			if true then
			 for subFruit,entry in pairs(g_currentMission.fruits) do
				if entry.windrowId ~= nil and entry.windrowId ~= 0 then
					local volume, area_gw, spraySum, greenValue = multiMowing.cutFruitArea(subFruit, x, z, x1, z1, x2, z2, true, true);
					if volume > 0 then
						local desc = FruitUtil.fruitIndexToDesc[subFruit];
						local desc2 = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_CHAFF];
						totalAreaMowed = totalAreaMowed + area_gw; --areaChanged is used for more things in multiMowing, so we need to do the stats in smaller steps
						if area_gw > 0.1 then
							if greenValue/area_gw > 0.5 then
								needGPSwindrow = true;
							end;
						end;
						area_gw = 0.5*area_gw*desc2.literPerSqm/desc.literPerSqm;
						
						local multi = 1;
						if spraySum > 0 then
							multi = 2;
						end;

						if multi*area_gw > areaGrass then
							doGW = true;
						end;
						
						if area_gw > maxFruitValue then
							maxFruitValue = area_gw;
							maxFruit = subFruit;
						end;
						
						areaChanged = areaChanged + multi*area_gw;
					end;
				end;
			 end;
			end; 
			 
             dropAreas[area.dropArea].valueAccum = dropAreas[area.dropArea].valueAccum + areaChanged;
			 if needGPSwindrow and areaChanged>0 then
				dropAreas[area.dropArea].needGreenWindrowScore = math.min(Utils.getNoNil(dropAreas[area.dropArea].needGreenWindrowScore,0)+1,10);
			 elseif areaChanged>0 then
				dropAreas[area.dropArea].needGreenWindrowScore = math.max(Utils.getNoNil(dropAreas[area.dropArea].needGreenWindrowScore,0)-1,-10);
			 end;
         else
			 local manureBonus = Utils.getNoNil(area.manureAcc);
			 local newManure = 0;
             areaChanged,newManure = multiMowing.updateMeadowArea(x, z, x1, z1, x2, z2, area.dropWindrow,manureBonus);
			 totalAreaMowed = totalAreaMowed + areaChanged; --areaChanged is used for more things in multiMowing, so we need to do the stats in smaller steps
			 area.manureAcc = math.min(newManure,100);
			 local areaGrass = areaChanged;
			 for subFruit,entry in pairs(g_currentMission.fruits) do
				if entry.windrowId ~= nil and entry.windrowId ~= 0 then

					local volume, area_gw, spraySum, greenValue = multiMowing.cutFruitArea(subFruit, x, z, x1, z1, x2, z2, true, true);
					
					if volume > 0 then					
						totalAreaMowed = totalAreaMowed + Utils.getNoNil(area_gw,0); --areaChanged is used for more things in multiMowing, so we need to do the stats in smaller steps
						local desc = FruitUtil.fruitIndexToDesc[subFruit];
						local desc2 = FruitUtil.fruitIndexToDesc[FruitUtil.FRUITTYPE_CHAFF];						
						if area_gw > 0.1 then
							if greenValue/area_gw > 0.5 then
								needGPSwindrow = true;
							end;
						end;
						
						area_gw = 0.5*area_gw*desc2.literPerSqm/desc.literPerSqm;
						
						local multi = 1;
						if spraySum > 0 then
							multi = 2;
						end;
						if multi*area_gw > areaGrass then
							doGW = true;
						end;
						
						if area_gw > maxFruitValue then
							maxFruitValue = area_gw;
							maxFruit = subFruit;
						end;
						
						areaChanged = areaChanged +multi*area_gw;
					end;
				end;
			end;
			
			-- save for sync block START
			area.doGW = doGW; --needed for mp sync
			area.GPSwindrow = doGPSwindrow and needGPSwindrow; --needed for mp sync
			area.lastDrop = 0;
			area.maxFruit = maxFruit;
			area.GPSwindrowFruit = GPSwindrowFruit;
			-- save for sync block END
			
			
			
			
             if not area.dropWindrow then
                 pickedUpWindrow = pickedUpWindrow + areaChanged;
             else
				if doGW then
					area.fruitAcc = Utils.getNoNil(area.fruitAcc,0) + areaChanged;
					local dropNow = math.floor(area.fruitAcc+0.001);
					dropNow = math.min(dropNow,g_currentMission.maxWindrowValue);
					area.fruitAcc = area.fruitAcc - dropNow;
					area.lastDrop = dropNow;
					if doGPSwindrow and needGPSwindrow then
						Utils.updateFruitWindrowArea(GPSwindrowFruit,x, z, x1, z1, x2, z2,dropNow,true,true)					
					else						
						Utils.updateFruitWindrowArea(maxFruit,x, z, x1, z1, x2, z2,dropNow,true,true)						
					end;
				end;
			 end
         end

         if areaChanged > 0 then
			 
             numAreasUsed = numAreasUsed + 1;
             if numAreasUsed ~= i then                
                 areas[numAreasUsed], areas[i] = areas[i], areas[numAreasUsed];
             end
         end
     end
	
	 --start debug print
		-- local desc = FruitUtil.fruitIndexToDesc[maxFruit];
		-- if desc ~= nil then
			-- print(desc.name)
		-- else
			-- print("no maxFruit (should be grass or nothing)")
		-- end;
	--end debug print
	
     for i=1, numDropAreas do
         local area = dropAreas[i];
		
		 --print(tostring(i).." "..tostring(area.valueAccum).." "..tostring(50*area.valueAccum/g_currentMission.maxWindrowValue))
		
         local dx = Utils.simWriteCompressedWorldPosition(area.x, params);
         local dz = Utils.simWriteCompressedWorldPosition(area.z, params);
         local dx1 = dx + Utils.simWriteCompressedWorldPosition(area.x1 - area.x, paramsRelative);
         local dz1 = dz + Utils.simWriteCompressedWorldPosition(area.z1 - area.z, paramsRelative);
         local dx2 = dx + Utils.simWriteCompressedWorldPosition(area.x2 - area.x, paramsRelative);
         local dz2 = dz + Utils.simWriteCompressedWorldPosition(area.z2 - area.z, paramsRelative);
 
         local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2);
         old = old + Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2);
		 
		local oldOther = 0;
		for subFruit,entry in pairs(g_currentMission.fruits) do
			if entry.windrowId ~= nil and entry.windrowId ~= 0 then
				
				local desc = FruitUtil.fruitIndexToDesc[subFruit];
				if desc.name ~= "grass" and desc.name~="dryGrass" then
				
					local tmp = Utils.getFruitWindrowArea(subFruit, dx, dz, dx1, dz1, dx2, dz2)
					oldOther = oldOther + Utils.getNoNil(tmp,0);
				end;
			end;
		end;

		if oldOther > old then
			doGW = true;
		end;
		
		old = old + oldOther;
		
		-- mp sync save block START
		area.doGW = doGW;
		area.doGPSwindrow = doGPSwindrow and Utils.getNoNil(area.needGreenWindrowScore,0) > 0;
		area.maxFruit = maxFruit;		
		area.GPSwindrowFruit = GPSwindrowFruit;		
		--mp sync save block END
		
         local value = (area.valueAccum+old) / total;
         -- round to the lower value, so the error we make is always positive as we place not enough windrows
         value = math.floor(value+0.001);
	
         if value >= 1 then
             value = math.min(value, g_currentMission.maxWindrowValue);
			 area.valueAccum = math.min(math.max(area.valueAccum+old - value*total, 0), 5*g_currentMission.maxWindrowValue);
             area.value = value;
			 
			if doGW then
				 Utils.destroyOtherFruit(maxFruit, dx, dz, dx1, dz1, dx2, dz2);
				if doGPSwindrow and area.needGreenWindrowScore > 0 then
					Utils.updateFruitWindrowArea(GPSwindrowFruit, dx, dz, dx1, dz1, dx2, dz2, value, true, true);--changed
				else
					Utils.updateFruitWindrowArea(maxFruit, dx, dz, dx1, dz1, dx2, dz2, value, true, true);--changed
				end;
			else
				 -- switch all dry grass to grass, and then destroy everything that is not grass
				 Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2);
				 Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2);			
				 Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2, value,true,false);
			end;
             numDropAreasUsed = numDropAreasUsed+1;
         else
             area.value = 0;
         end
     end
     return numAreasUsed, numDropAreasUsed, pickedUpWindrow, totalAreaMowed;
 end;
 
 
 function multiMowing.cutFruitArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, destroySpray, destroySeedingWidth)
  local ids = g_currentMission.fruits[fruitId]
  if ids == nil or ids.id == 0 then
    return 0
  end
  local id = ids.id
  local desc = FruitUtil.fruitIndexToDesc[fruitId]
  local value = desc.cutState + 1
  local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
  local detailId = g_currentMission.terrainDetailId
  local spraySum = 0
  if destroySpray then
    setDensityMaskParams(detailId, "between", 2, desc.cutState)
    spraySum = setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, g_currentMission.sprayChannel, 1, id, 0, g_currentMission.numFruitStateChannels, 0)
    setDensityMaskParams(detailId, "greater", 0)
  end
  if desc.useSeedingWidth and (destroySeedingWidth == nil or destroySeedingWidth) then
    setDensityMaskParams(detailId, "between", desc.minHarvestingGrowthState + 1, desc.maxHarvestingGrowthState + 1)
    local detailTypeValue = 2 ^ g_currentMission.sowingChannel
    setDensityMaskedParallelogram(detailId, x, z, widthX, widthZ, heightX, heightZ, g_currentMission.terrainDetailTypeFirstChannel, g_currentMission.terrainDetailTypeNumChannels, id, 0, g_currentMission.numFruitStateChannels, detailTypeValue)
    setDensityMaskParams(detailId, "greater", 0)
  end
  setDensityReturnValueShift(id, -1)
  
  local numPixSum = 0;
  local pixels, numPixels
  local pixelsSum = 0;
  
  local greenPart = 0;
  
  for state = 2,desc.cutState-1,1 do
	  setDensityCompareParams(id, "between", state-1, state + 1)
	  pixels, numPixels = setDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels, value)
	  local factor = 1.0;
	  if state > desc.maxHarvestingGrowthState then --we are rotten...
		factor = .2;
	  elseif state < desc.minHarvestingGrowthState-1 then --  (-1) because we can harvest green wheat, green barley etc
	    factor = 1/(2^((desc.minHarvestingGrowthState-1-state)^2))
	  end;
	  
	  if state < desc.minHarvestingGrowthState then
		greenPart = greenPart + factor*numPixels;
	  end;
	  
	  numPixSum = numPixSum + factor*numPixels;
	  pixelsSum = pixelsSum + Utils.getNoNil(pixels);
  end;
  
  setDensityCompareParams(id, "greater", -1)
  setDensityReturnValueShift(id, 0)
  if desc.allowsPartialGrowthState then
    return pixelsSum / desc.maxHarvestingGrowthState, numPixSum, spraySum, greenPart
  else
    return numPixSum, numPixSum, spraySum, greenPart
  end
end

function multiMowing.updateMeadowArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, dropWindrow,addFromManure)
  local manure = 0;
  if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURELIQUID] ~= nil then
	 manure = Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_MANURELIQUID, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0,true,false);
  end;
  if g_currentMission.fruits[FruitUtil.FRUITTYPE_MANURESOLID] ~= nil then
	 manure = manure + Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_MANURESOLID, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, 0,true,false);
  end;
  multiMowing.manureSum = multiMowing.manureSum + manure;
  manure = manure + Utils.getNoNil(addFromManure,0)
  
  local addWindRow = math.min(1+multiMowing.manureFactor*math.max(manure,0),2);
  
  if dropWindrow == nil or dropWindrow then
    Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, addWindRow);  
  end;
  local grasCut = Utils.cutFruitArea(FruitUtil.FRUITTYPE_GRASS, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, true, true);
  
	manure = math.max(manure - 0.9*grasCut*(addWindRow-1),0);
	--print(manure," ",grasCut," ",grasCut * addWindRow)
	grasCut = grasCut * addWindRow;
	
	return grasCut, manure
end;

-- "fix" for old slurry/manure, not needed anymore
-- multiMowing.updateManureWindrowArea = function(windrowId, x, z, x1, z1, x2, z2)
	-- local dx, dz, dwidthX, dwidthZ, dheightX, dheightZ = Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2)
	-- setDensityParallelogram(windrowId, dx, dz, dwidthX, dwidthZ, dheightX, dheightZ, 0, 1, 1);	
-- end;


function multiMowing:newWriteStream(streamId, connection)
    streamWriteUIntN(streamId, self.numAreas, 3);
    streamWriteUIntN(streamId, self.numDropAreasUsed, 3);

    local params = g_currentMission.areaCompressionParams;
    local paramsRelative = g_currentMission.areaRelativeCompressionParams;
    for i=1, self.numAreas do
        local area = self.areas[i];
        Utils.writeCompressedWorldPosition(streamId, area.x, params);
        Utils.writeCompressedWorldPosition(streamId, area.z, params);
        Utils.writeCompressedWorldPosition(streamId, area.x1 - area.x, paramsRelative);
        Utils.writeCompressedWorldPosition(streamId, area.z1 - area.z, paramsRelative);
        Utils.writeCompressedWorldPosition(streamId, area.x2 - area.x, paramsRelative);
        Utils.writeCompressedWorldPosition(streamId, area.z2 - area.z, paramsRelative);
        streamWriteBool(streamId, (area.dropArea == nil and area.dropWindrow))
		if streamWriteBool(streamId, (area.dropArea == nil and area.doGW)) then			
			streamWriteFloat32(streamId, (area.lastDrop))
			
			if area.GPSwindrow then
				streamWriteUIntN(streamId, area.GPSwindrowFruit, FruitUtil.sendNumBits);
			else
				streamWriteUIntN(streamId, area.maxFruit, FruitUtil.sendNumBits);
			end;			
		end;		
    end;--done till here
	
	
    if self.numDropAreasUsed > 0 then
        for i=1, self.numDropAreas do
            local area = self.dropAreas[i];
            if area.value >= 1 then
                Utils.writeCompressedWorldPosition(streamId, area.x, params);
                Utils.writeCompressedWorldPosition(streamId, area.z, params);
                Utils.writeCompressedWorldPosition(streamId, area.x1 - area.x, paramsRelative);
                Utils.writeCompressedWorldPosition(streamId, area.z1 - area.z, paramsRelative);
                Utils.writeCompressedWorldPosition(streamId, area.x2 - area.x, paramsRelative);
                Utils.writeCompressedWorldPosition(streamId, area.z2 - area.z, paramsRelative);
                streamWriteUIntN(streamId, area.value, g_currentMission.numWindrowChannels);
				if streamWriteBool(streamId, area.doGW) then
					if area.doGPSwindrow then
						streamWriteUIntN(streamId, area.GPSwindrowFruit, FruitUtil.sendNumBits);
					else
						streamWriteUIntN(streamId, area.maxFruit, FruitUtil.sendNumBits);
					end;
				end;				
            end
        end
    end
end;


function multiMowing:newReadStream(streamId, connection)
    local numAreas = streamReadUIntN(streamId, 3);
    local numDropAreas = streamReadUIntN(streamId, 3);

    local params = g_currentMission.areaCompressionParams;
    local paramsRelative = g_currentMission.areaRelativeCompressionParams;
    for i=1, numAreas do
        local x = Utils.readCompressedWorldPosition(streamId, params);
        local z = Utils.readCompressedWorldPosition(streamId, params);
        local x1 = x + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local z1 = z + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local x2 = x + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local z2 = z + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        if streamReadBool(streamId) then
            Utils.updateMeadowArea(x, z, x1, z1, x2, z2, true);
        else
            Utils.updateMeadowArea(x, z, x1, z1, x2, z2, false);
        end
		for subFruit,entry in pairs(g_currentMission.fruits) do
			if entry.windrowId ~= nil and entry.windrowId ~= 0 then
				multiMowing.cutFruitArea(subFruit, x, z, x1, z1, x2, z2, true, true);
			end;
		end;		
		
		if streamReadBool(streamId) then
			local lastDrop = streamReadFloat32(streamId);
			local placeFruit = streamReadUIntN(streamId, FruitUtil.sendNumBits);			
			Utils.updateFruitWindrowArea(placeFruit,x, z, x1, z1, x2, z2,lastDrop,true,true);			
		end;
    end
	
	
    for i=1, numDropAreas do
        local dx = Utils.readCompressedWorldPosition(streamId, params);
        local dz = Utils.readCompressedWorldPosition(streamId, params);
        local dx1 = dx + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local dz1 = dz + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local dx2 = dx + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local dz2 = dz + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local v = streamReadUIntN(streamId, g_currentMission.numWindrowChannels);
		
		if streamReadBool(streamId) then --doGW
			local placeFruit = streamReadUIntN(streamId, FruitUtil.sendNumBits);
			Utils.destroyOtherFruit(placeFruit, dx, dz, dx1, dz1, dx2, dz2);			
			Utils.updateFruitWindrowArea(placeFruit, dx, dz, dx1, dz1, dx2, dz2, v, true, true);			
		else			
			Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, dx, dz, dx1, dz1, dx2, dz2);
			Utils.destroyOtherFruit(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2);
			Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, dx, dz, dx1, dz1, dx2, dz2, v, true, false);
		end;        
    end;
end;